<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Prix extends Model 
{

    protected $table = 'prix';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_vin', 'montant', 'quantite', 'taille', 'volume', 'description', 'image');
    protected $visible = array('id_vin', 'montant', 'quantite', 'taille', 'volume', 'description', 'image');

    public function vin()
    {
        return $this->belongsTo('App\Models\Vin', 'id_vin');
    }

    public function lignes_ventes()
    {
        return $this->hasMany('App\Models\Ligne_vente', 'id_prix');
    }

}